IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_TRILHO_EXCESSO]') AND type in (N'P', N'TF'))
DROP FUNCTION [dbo].[UFD_TRILHO_EXCESSO]  
GO

/****** Object:  UserDefinedFunction [dbo].[UFD_TRILHO_EXCESSO]    Script Date: 06/26/2012 15:18:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[UFD_TRILHO_EXCESSO] (@CD_EMP INT, @FILIAL_ORIG INT, @CD_DEST INT, @TP_DEST INT=0)	
 
RETURNS @RS_RETORNO TABLE (	CD_EMP				INT,
							CD_CTR_DEPO			INT,
							CD_EXCESSO_MAQ		INT,
							CD_FILIAL_ORIG		INT,
							CD_FILIAL_DEST		INT,
							CD_PROD				INT, 
							VLR_CUSTO			MONEY,
							QTDE_ATEND			MONEY,
							MEDIAF				MONEY,
							ESEG				MONEY,
							EMAX				MONEY )

AS
BEGIN


	IF @TP_DEST =0 
	BEGIN
		INSERT INTO @RS_RETORNO
		SELECT	
			@CD_EMP,
			E.CD_CTR_DEPO,
			E.CD_EXCESSO_MAQ,
			@FILIAL_ORIG,
			@CD_DEST,
			e.CD_PROD, 
			e.VLR_CUSTO,
			QTDE_ATEND = ROUND( CASE WHEN e.EXCESSO > n.NECESSIDADE THEN 
								n.NECESSIDADE ELSE e.EXCESSO END,0),
			e.MEDIAF,
			e.ESEG,
			e.EMAX
		FROM
			TRILHO_MAQ_EXCESSO  e 
			INNER JOIN dbo.V_TRILHO_PROD_NECESSIDADE n ON 
			e.CD_EMP		= n.CD_EMP	AND 
			e.CD_CTR_DEPO	= n.CD_CTR_DEPO AND 
			e.CD_PROD		= n.CD_PROD AND 
			e.DT_MOV		= n.DT_MOV 
		WHERE 
			n.CD_EMP=@CD_EMP 
			AND e.CD_FILIAL=@FILIAL_ORIG 
			AND n.CD_FILIAL=@CD_DEST
			AND  e.EXCESSO > 0 
			AND (ROUND( CASE WHEN e.EXCESSO > n.NECESSIDADE THEN 
								n.NECESSIDADE ELSE e.EXCESSO END,0)) > 0
	END


	IF @TP_DEST =1 
	BEGIN
		
		INSERT INTO @RS_RETORNO
		SELECT	
			@CD_EMP,
			E.CD_CTR_DEPO,
			E.CD_EXCESSO_MAQ,
			@FILIAL_ORIG,
			@CD_DEST,
			e.CD_PROD, 
			e.VLR_CUSTO,
			QTDE_ATEND = ROUND( CASE WHEN e.EXCESSO > n.NECESSIDADE THEN 
								n.NECESSIDADE ELSE e.EXCESSO END,0),
			e.MEDIAF,
			e.ESEG,
			e.EMAX
		FROM
			TRILHO_MAQ_EXCESSO  e 
			INNER JOIN dbo.V_TRILHO_PROD_FORN n ON 
			e.CD_EMP		= n.CD_EMP	AND 
			e.CD_CTR_DEPO	= n.CD_CTR_DEPO AND 
			e.CD_FILIAL 	= n.CD_FILIAL  AND 
			e.CD_PROD		= n.CD_PROD AND 
			e.DT_MOV		= n.DT_MOV 
		WHERE 
			n.CD_EMP=@CD_EMP 
			AND e.CD_FILIAL=@FILIAL_ORIG 
			AND n.CD_FORN  =@CD_DEST
			AND E.DT_MOV   =dbo.F_HOJE()
			AND e.EXCESSO > 0 
			AND (ROUND( CASE WHEN e.EXCESSO > n.NECESSIDADE THEN 
								n.NECESSIDADE ELSE e.EXCESSO END,0)) > 0
	END

	RETURN;
END



GO


